<?php
require_once __DIR__ . '/../../lib/Config.php';
require_once __DIR__ . '/../../lib/DB.php';
require_once __DIR__ . '/../../lib/Auth.php';

Config::load(__DIR__ . '/../../.env');

header('Content-Type: application/json');

if (!Auth::check()) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);
$id = $input['id'] ?? null;
$action = $input['action'] ?? null;

if (!$id || !$action) {
    http_response_code(400);
    echo json_encode(['error' => 'Missing parameters']);
    exit;
}

try {
    if ($action === 'delete') {
        DB::query("DELETE FROM posts WHERE id = ?", [$id]);
        echo json_encode(['success' => true, 'message' => 'Post deleted']);
    } elseif ($action === 'publish') {
        DB::query("UPDATE posts SET status = 'published', published_at = NOW() WHERE id = ?", [$id]);
        echo json_encode(['success' => true, 'message' => 'Post published']);
    } elseif ($action === 'unpublish') {
        DB::query("UPDATE posts SET status = 'draft' WHERE id = ?", [$id]);
        echo json_encode(['success' => true, 'message' => 'Post unpublished']);
    } else {
        throw new Exception("Invalid action");
    }
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}
