<?php
// install.php - Single File Installer for BioVibe
session_start();

// Helper to write .env file
function writeEnvFile($data) {
    $content = "";
    foreach ($data as $key => $value) {
        $content .= "$key=$value\n";
    }
    return file_put_contents(__DIR__ . '/../.env', $content);
}

// Helper to execute SQL
function executeSql($pdo, $sql) {
    try {
        $pdo->exec($sql);
        return true;
    } catch (PDOException $e) {
        return "Error: " . $e->getMessage();
    }
}

$message = "";
$status = ""; // success or error

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $host = $_POST['db_host'] ?? 'localhost';
    $name = $_POST['db_name'] ?? '';
    $user = $_POST['db_user'] ?? '';
    $pass = $_POST['db_pass'] ?? '';
    $url  = $_POST['app_url'] ?? 'http://' . $_SERVER['HTTP_HOST'];

    if (empty($name) || empty($user)) {
        $message = "Database Name and User are required.";
        $status = "error";
    } else {
        try {
            // 1. Test Connection
            $dsn = "mysql:host=$host;dbname=$name;charset=utf8mb4";
            $pdo = new PDO($dsn, $user, $pass, [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
            ]);

            // 2. Write .env file
            $envData = [
                'APP_ENV' => 'production',
                'APP_URL' => $url,
                'APP_NAME' => '"BioVibe"',
                'DB_HOST' => $host,
                'DB_NAME' => $name,
                'DB_USER' => $user,
                'DB_PASS' => $pass,
                'AI_API_KEY' => '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',
                'AI_MODEL' => 'gpt-3.5-turbo',
                'AI_MAX_TOKENS' => '1000',
                'GOOGLE_AUTH_JSON_PATH' => '../google-service-account.json',
                'RSS_FEEDS' => 'https://trends.google.com/trending/rss?geo=US,https://news.google.com/rss/search?q=obituary+died+when:1d&hl=en-US&gl=US&ceid=US:en',
                'PLAGIARISM_THRESHOLD' => '0.7',
                'ADMIN_PATH_SECRET' => 'admin'
            ];

            if (writeEnvFile($envData) === false) {
                throw new Exception("Could not write .env file. Check permissions of the root folder.");
            }

            // 3. Run SQL Schema
            // Combined SQL from schema.sql and update_v2.sql
            $sql = <<<SQL
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";

CREATE TABLE IF NOT EXISTS `users` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `username` VARCHAR(100) UNIQUE NOT NULL,
  `password_hash` VARCHAR(255) NOT NULL,
  `role` ENUM('admin','editor') DEFAULT 'editor',
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `posts` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `title` VARCHAR(255) NOT NULL,
  `slug` VARCHAR(255) UNIQUE NOT NULL,
  `content` MEDIUMTEXT NOT NULL,
  `excerpt` TEXT,
  `source_url` VARCHAR(2083),
  `source_name` VARCHAR(255),
  `author_name` VARCHAR(255),
  `fingerprint` VARCHAR(64) NOT NULL COMMENT 'Hash for deduplication',
  `status` ENUM('published','draft','queued') DEFAULT 'published',
  `indexed_status` ENUM('unknown','requested','indexed','failed') DEFAULT 'unknown',
  `views` INT DEFAULT 0,
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  `published_at` DATETIME NULL,
  INDEX `idx_status` (`status`),
  INDEX `idx_fingerprint` (`fingerprint`),
  INDEX `idx_published_at` (`published_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `logs` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `level` VARCHAR(20) DEFAULT 'INFO',
  `source` VARCHAR(50) DEFAULT 'SYSTEM',
  `message` TEXT,
  `meta` JSON,
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `stats_daily` (
  `day` DATE PRIMARY KEY,
  `posts_published` INT DEFAULT 0,
  `api_calls` INT DEFAULT 0,
  `views` INT DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `indexing_log` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `post_id` INT NOT NULL,
  `status` VARCHAR(50),
  `response_code` INT,
  `response_body` TEXT,
  `attempted_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (`post_id`) REFERENCES `posts`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `analytics_visits` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `post_id` INT NULL,
  `ip_hash` VARCHAR(64) NOT NULL,
  `user_agent` TEXT,
  `browser` VARCHAR(50),
  `platform` VARCHAR(50),
  `country_code` VARCHAR(2),
  `city` VARCHAR(100),
  `region` VARCHAR(100),
  `visited_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  INDEX `idx_visited_at` (`visited_at`),
  INDEX `idx_post_id` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Create Admin if not exists
INSERT IGNORE INTO `users` (`username`, `password_hash`, `role`) VALUES
('admin', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin');
SQL;

            $pdo->exec($sql);

            $message = "Installation Successful! Database tables created and .env file updated. <br><strong>Please delete this install.php file immediately.</strong> <br><a href='/'>Go to Homepage</a>";
            $status = "success";

        } catch (Exception $e) {
            $message = "Installation Failed: " . $e->getMessage();
            $status = "error";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>BioVibe Installer</title>
    <style>
        body { font-family: system-ui, sans-serif; background: #f3f4f6; display: flex; justify-content: center; align-items: center; min-height: 100vh; margin: 0; }
        .card { background: white; padding: 2rem; border-radius: 1rem; box-shadow: 0 4px 6px -1px rgba(0,0,0,0.1); width: 100%; max-width: 400px; }
        h1 { margin-top: 0; color: #111827; font-size: 1.5rem; text-align: center; }
        .form-group { margin-bottom: 1rem; }
        label { display: block; margin-bottom: 0.5rem; color: #374151; font-weight: 500; }
        input { width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 0.5rem; box-sizing: border-box; }
        button { width: 100%; background: #00f2ea; color: #000; font-weight: bold; padding: 0.75rem; border: none; border-radius: 0.5rem; cursor: pointer; transition: opacity 0.2s; }
        button:hover { opacity: 0.9; }
        .alert { padding: 1rem; border-radius: 0.5rem; margin-bottom: 1rem; font-size: 0.9rem; }
        .alert-error { background: #fee2e2; color: #991b1b; }
        .alert-success { background: #d1fae5; color: #065f46; }
    </style>
</head>
<body>
    <div class="card">
        <h1>BioVibe Installer</h1>
        
        <?php if ($message): ?>
            <div class="alert alert-<?php echo $status; ?>">
                <?php echo $message; ?>
            </div>
        <?php endif; ?>

        <?php if ($status !== 'success'): ?>
        <form method="POST">
            <div class="form-group">
                <label>App URL</label>
                <input type="text" name="app_url" value="<?php echo 'http://' . $_SERVER['HTTP_HOST'] . '/bio'; ?>" required>
            </div>
            <div class="form-group">
                <label>Database Host</label>
                <input type="text" name="db_host" value="localhost" required>
            </div>
            <div class="form-group">
                <label>Database Name</label>
                <input type="text" name="db_name" placeholder="e.g. kanoyvdo_biovibe" required>
            </div>
            <div class="form-group">
                <label>Database User</label>
                <input type="text" name="db_user" placeholder="e.g. kanoyvdo_user" required>
            </div>
            <div class="form-group">
                <label>Database Password</label>
                <input type="password" name="db_pass" placeholder="Enter password" required>
            </div>
            <button type="submit">Install & Create Tables</button>
        </form>
        <?php endif; ?>
    </div>
</body>
</html>
