-- Database Schema for Biography & Obituary Autopost Platform
-- Combined Schema (V2)

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";

-- Users Table
CREATE TABLE IF NOT EXISTS `users` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `username` VARCHAR(100) UNIQUE NOT NULL,
  `password_hash` VARCHAR(255) NOT NULL,
  `role` ENUM('admin','editor') DEFAULT 'editor',
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Posts Table
CREATE TABLE IF NOT EXISTS `posts` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `title` VARCHAR(255) NOT NULL,
  `slug` VARCHAR(255) UNIQUE NOT NULL,
  `content` MEDIUMTEXT NOT NULL,
  `excerpt` TEXT,
  `source_url` VARCHAR(2083),
  `source_name` VARCHAR(255),
  `author_name` VARCHAR(255),
  `fingerprint` VARCHAR(64) NOT NULL COMMENT 'Hash for deduplication',
  `status` ENUM('published','draft','queued') DEFAULT 'published',
  `indexed_status` ENUM('unknown','requested','indexed','failed') DEFAULT 'unknown',
  `views` INT DEFAULT 0,
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  `published_at` DATETIME NULL,
  INDEX `idx_status` (`status`),
  INDEX `idx_fingerprint` (`fingerprint`),
  INDEX `idx_published_at` (`published_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Logs Table
CREATE TABLE IF NOT EXISTS `logs` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `level` VARCHAR(20) DEFAULT 'INFO',
  `source` VARCHAR(50) DEFAULT 'SYSTEM',
  `message` TEXT,
  `meta` JSON,
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Stats Table (Daily Aggregates)
CREATE TABLE IF NOT EXISTS `stats_daily` (
  `day` DATE PRIMARY KEY,
  `posts_published` INT DEFAULT 0,
  `api_calls` INT DEFAULT 0,
  `views` INT DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Indexing Queue/History
CREATE TABLE IF NOT EXISTS `indexing_log` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `post_id` INT NOT NULL,
  `status` VARCHAR(50),
  `response_code` INT,
  `response_body` TEXT,
  `attempted_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (`post_id`) REFERENCES `posts`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Analytics Visits Table (V2 Feature)
CREATE TABLE IF NOT EXISTS `analytics_visits` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `post_id` INT NULL,
  `ip_hash` VARCHAR(64) NOT NULL,
  `user_agent` TEXT,
  `browser` VARCHAR(50),
  `platform` VARCHAR(50),
  `country_code` VARCHAR(2),
  `city` VARCHAR(100),
  `region` VARCHAR(100),
  `visited_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  INDEX `idx_visited_at` (`visited_at`),
  INDEX `idx_post_id` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Default Admin User (Password: admin123 - CHANGE IMMEDIATELY)
INSERT IGNORE INTO `users` (`username`, `password_hash`, `role`) VALUES
('admin', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin');
